#{{uc_id}} {
  box-sizing: border-box;
  display: flex;
  align-items: center;
  overflow: hidden;
  direction:ltr;
}

#{{uc_id}} .ue-marquee-content {
  display: flex;
  will-change: transform;
  animation: {{ue_animation}}{{uc_id}} {{ue_speed}}s linear infinite running;
  animation-delay: 250ms;
  {% if ue_animation == "marquee-up" or ue_animation == "marquee-down" %}
      	flex-direction: column;
  		width: 100%;
  {% endif %}
}

{% if pause_on_hover == "true" %}
#{{uc_id}} .ue-marquee-content:hover {
  animation-play-state: paused;
}
{% endif %}

#{{uc_id}} .ue-marquee-tag {
  width: auto;
  display: flex;
  align-items: center;
  justify-content: center;
  transition: all 0.2s ease;
  white-space: nowrap;
  direction:{{item_direction}};
}

#{{uc_id}} .ue-marquee-tag a {
  display: flex;
  align-items: center;
  justify-content: center;
  white-space: nowrap;
  -webkit-text-stroke: {{item_stroke_width}}px {{item_stroke_color}};
}
#{{uc_id}} .ue-marquee-graphic{
  overflow:hidden;
}
#{{uc_id}} .ue-marquee-tag-icon {
  flex-grow: 0;   
  flex-shrink: 0;
  line-height:1em;
}
#{{uc_id}} .ue-marquee-tag-image {
  flex-grow: 0;   
  flex-shrink: 0;
  line-height:1em;
}

#{{uc_id}} .ue_marq_text_wrap{
  display:flex;
  flex-direction: row;
  align-items: center;
  {% if ue_animation == "marquee-up" or ue_animation == "marquee-down" %}
    white-space: normal;
  {% endif %}
}

@keyframes marquee{{uc_id}} {
  0% {
 	-webkit-transform: translateX(0);
    transform: translateX(0);
  }
  100% {
    -webkit-transform: translate(-50%);
    transform: translate(-50%);
  }
}

@keyframes marquee-reverse{{uc_id}} {
  0% {
 	-webkit-transform: translateX(-50%);
    transform: translateX(-50%);
  }
  100% {
    -webkit-transform: translate(0%);
    transform: translate(0%);
  }
}

@keyframes marquee-up{{uc_id}} {
	from {transform: translate(0, 25%)}
	to {transform: translate(0, -25%)}
}

@keyframes marquee-down{{uc_id}} {
	from {transform: translate(0, -25%)}
	to {transform: translate(0, 25%)}
}